# Standard build infrastructure for APS3
# This file must be include'd as the first thing in any APS3 Makefile
#
# The Makefile should contain a definition of the variable SOURCES, which
# contains all source files that need to be built
#
# Any Makefile targets that require the resulting objects should refer to them
# as $(OBJS).
#

ifeq (${CORTUS_OS},cygwin)
   export CORTUS_PATH=cygpath -am
   export EXE=.exe
else
   ifeq (${CORTUS_OS},eclipse)
      export CORTUS_PATH=cygpath -am
      export EXE=.exe
   else 
      export CORTUS_PATH=echo
      export EXE=
   endif   
endif

##############################################################################
#
# Force "all" to be default target
#
all:

##############################################################################
#
# Select tools
#
   export APS3_GCC     = aps3-gcc
   export APS3_CXX     = aps3-g++
   export APS3_CPP     = aps3-cpp
   export APS3_LD      = aps3-ld
   export APS3_AS      = aps3-as
   export APS3_AR      = aps3-ar
   export APS3_RANLIB  = aps3-ranlib
   export APS3_GDB     = aps3-gdb
   export APS3_OBJCOPY = aps3-objcopy
   export APS3_OBJDUMP = aps3-objdump

CC = aps3-gcc
CXX = aps3-g++
AR = aps3-ar
OBJCOPY = aps3-objcopy
RANLIB = aps3-ranlib

##################################################################################
# Other tools
################################################################################

export SREC2VMEM   = ${CORTUS_ROOT}/tools/bin/srec2vmem${EXE}
export SREC2V      = ${CORTUS_ROOT}/tools/bin/srec2v${EXE}

#############################################################################
#
# $(CONF) is used in all filenames that depend on the specific build
#
CONF = $(BUILD:%=-%)

##############################################################################
#
# Create list of object files by substituting any source extension (for all
# files in $(SOURCES)) with ".o"
#
OBJDIR = obj$(CONF)
vpath %.o $(OBJDIR)
OBJS = $(patsubst %,$(OBJDIR)/%.o,$(basename $(SOURCES)))

##############################################################################
#
# Multiple-configuration support
#
# Set "BUILD=<name>" from environment to select a specific configuration.
# Standard configurations are "debug" and "rel".
#

# Global options
CFLAGS_all = -Wall -W -mmul -mshift
CXXFLAGS_all = -Wall -W -mmul -mshift
LDFLAGS_all =

# Options for debug build
CFLAGS_debug = -g -Os
CXXFLAGS_debug = -g -Os
LDFLAGS_debug = 

# Options for release build
CFLAGS_rel = -Os
CXXFLAGS_rel = -Os
LDFLAGS_rel =

# Extra flags
EXTRA_CFLAGS = -G0 
EXTRA_CXXFLAGS = -G0
EXTRA_LDFLAGS = -G0 

# Default build type is "debug"
BUILD ?= debug

ifndef CFLAGS_$(BUILD)
$(error Unknown build type $(BUILD))
endif
CFLAGS = $(CFLAGS_$(BUILD)) $(CFLAGS_all) $(EXTRA_CFLAGS)
CXXFLAGS = $(CXXFLAGS_$(BUILD)) $(CXXFLAGS_all) $(EXTRA_CFLAGS)
LDFLAGS = $(LDFLAGS_$(BUILD)) $(LDFLAGS_all) $(EXTRA_LDFLAGS)

##############################################################################
#
# Automatic dependency support
#
# * Compilation of "file.c" or "file.cpp" into "$(OBJDIR)/file.o" produces
#   dependencies in "$(OBJDIR)/file.o.d"
# * "$(OBJDIR)/dep" is the concatenation of all "$(OBJDIR)/*.d" files, and is
#   included in the Makefile
#
ifneq ($(MAKECMDGOALS),clean)
ifneq ($(wildcard $(OBJDIR)/*.d),)
$(OBJDIR)/dep: $(OBJDIR)/*.d
	cat $^ > $@
-include $(OBJDIR)/dep
endif
endif

.PHONY : clean clean-deps
clean : clean-deps
clean-deps :
	$(RM) $(OBJDIR)/*.d $(OBJDIR)/dep

##############################################################################
#
# Compiler invocation rules
# The compiler creates both the output object file (*.o) and a dependency list
# (*.d) for this file
#
#$(OBJDIR)/%.o: %.cpp
#	@mkdir -p $(OBJDIR)
#	$(COMPILE.cc) -MMD -MF $(OBJDIR)/$(@F).d $< -c -o $@
#$(OBJDIR)/%.o: %.c
#	@mkdir -p $(OBJDIR)
#	$(COMPILE.c) -MMD -MF $(OBJDIR)/$(@F).d $< -c -o $@
